SET Version=2.06
REM Updated 09/15/2015
REM By Angelotti, JackCY, and Dark_wizzie.

@ECHO off
setlocal enabledelayedexpansion

CLS
PUSHD "%CD%\test"

:info

ECHO ================================================================
ECHO                   x264-64 Stability test v2.06
ECHO ================================================================

ECHO.
x264-64 --version
ECHO.

:configuration

SET "logHeader1=                     x264-64 Stability test"
SET "logHeader2================================================================="
SET "logPrefix=x264-log_"
SET "logExtension=rtf"
SET "logViewer=wordpad"
SET "encoderLogPrefix=encoderLoop"
SET "encoderLogExtension=log"
SET "increment=1"

:parameters

REM  -h --help, -n --name, -l --loops, -t --threads, -p --priority

SHIFT
IF [%0]==[] GOTO paramsdone
IF [%0]==[-h] GOTO phelp
IF [%0]==[--help] GOTO phelp
IF [%0]==[-n] GOTO pname
IF [%0]==[--name] GOTO pname
IF [%0]==[-l] GOTO ploops
IF [%0]==[--loops] GOTO ploops
IF [%0]==[-t] GOTO pthreads
IF [%0]==[--threads] GOTO pthreads
IF [%0]==[-p] GOTO ppriority
IF [%0]==[--priority] GOTO ppriority

ECHO Invalid parameter specified: %0
GOTO exit

:phelp
ECHO x264-64 Stability test
ECHO v%Version% for OCN by JackCY
ECHO.
ECHO Usage: batch.bat [options]
ECHO.
ECHO -h, --help        This help.
ECHO -n, --name        Log name.
ECHO -l, --loops       Number of loops [0, 1, ..., infinity].
ECHO -t, --threads     Number of threads [auto, 8, 16]. RECOMMENDED VALUE: 16.
ECHO -p, --priority    Priority [low, belownormal, normal, abovenormal, high].
ECHO.
GOTO exit

:pname
SHIFT
IF [%0]==[] (
        ECHO Invalid parameter value: name
        GOTO exit
) ELSE (
        SET logName=%~0
        GOTO parameters
)
:ploops
SHIFT
IF [%0]==[] (
        ECHO Invalid parameter value: loops
        GOTO exit
) ELSE (
        SET loops=%0
        GOTO parameters
)
:pthreads
SHIFT
IF [%0]==[] (
        ECHO Invalid parameter value: threads
        GOTO exit
) ELSE (
        SET threads=%0
        GOTO parameters
)
:ppriority
SHIFT
IF [%0]==[] (
        ECHO Invalid parameter value: priority
        GOTO exit
) ELSE (
        SET priority=%0
        GOTO parameters
)

:paramsdone

ECHO ==== Configuration =============================================
ECHO.

IF NOT DEFINED logName SET /p logName="Log name = "
IF [!logName!]==[] (
        SET "logName=OCN"
)
ECHO Log name = %logPrefix%%logName%.%logExtension%

IF NOT DEFINED loops (
        ECHO [0, 1, ..., infinity]
        SET /p loops="Loops    = "
        IF [!loops!]==[] (
                SET "loops=50"
                ECHO Loops    = !loops!
        )
) ELSE (
        ECHO Loops    = !loops!
)
IF NOT DEFINED threads (
        ECHO [auto, 8, 16]
        SET /p threads="Threads  = "
        IF [!threads!]==[] (
                SET "threads=16"
                ECHO Threads  = !threads!
        )
) ELSE (
        ECHO Threads  = !threads!
)
IF NOT DEFINED priority (
        ECHO [low, belownormal, normal, abovenormal, high]
        SET /p priority="Priority = "
        IF [!priority!]==[] (
                SET "priority=normal"
                ECHO Priority = !priority!
        )
) ELSE (
        ECHO Priority = !priority!
)
ECHO.

:reset

DEL "%encoderLogPrefix%*.%encoderLogExtension%" >NUL 2>&1
DEL "*.stats" >NUL 2>&1
DEL "*.mbtree" >NUL 2>&1
DEL "encode.mkv" >NUL 2>&1
DEL "%logPrefix%*.%logExtension%" >NUL 2>&1

:log-header

ECHO %logHeader2%>> "%logPrefix%%logName%.%logExtension%"
ECHO %logHeader1%>> "%logPrefix%%logName%.%logExtension%"
ECHO %logHeader2%>> "%logPrefix%%logName%.%logExtension%"
ECHO.>> "%logPrefix%%logName%.%logExtension%"
x264-64 --version >> "%logPrefix%%logName%.%logExtension%"
ECHO.>> "%logPrefix%%logName%.%logExtension%"

ECHO ==== Configuration =============================================>> "%logPrefix%%logName%.%logExtension%"
ECHO.>> "%logPrefix%%logName%.%logExtension%"
ECHO Log name = %logPrefix%%logName%.%logExtension% >> "%logPrefix%%logName%.%logExtension%"
ECHO Loops    = %loops% >> "%logPrefix%%logName%.%logExtension%"
ECHO Threads  = %threads% >> "%logPrefix%%logName%.%logExtension%"
ECHO Priority = %priority% >> "%logPrefix%%logName%.%logExtension%"
ECHO.>> "%logPrefix%%logName%.%logExtension%"

:encode

ECHO ==== Results ===================================================|tee -a "%logPrefix%%logName%.%logExtension%"
ECHO.|tee -a "%logPrefix%%logName%.%logExtension%"
ECHO Start:  !TIME! !DATE!|tee -a "%logPrefix%%logName%.%logExtension%"
ECHO.|tee -a "%logPrefix%%logName%.%logExtension%"

IF [%loops%]==[infinity] (
        SET "increment=0"
        SET "loops=10"
)
SET "counter=0"

FOR /L %%n in (1,%increment%,%loops%) do (
        SET /A counter=!counter!+1
        ECHO Loop !counter!: !TIME!|tee -a "%logPrefix%%logName%.%logExtension%"
        
        start /%priority% /b x264-64 --quiet --preset slower --crf 16 --threads %threads% --rc-lookahead 40 --aq-strength 1.5 --merange 24 --subme 10 --psy-rd 1.5:0 --video-filter crop:0,20,0,22/resize:width=1920,height=1040,method=lanczos4 --thread-input --output "encode.mkv" "test-1080p.mp4" --aud 2>&1 | tee "%encoderLogPrefix%%%n.%encoderLogExtension%"
        
        grep -U "encoded" "%encoderLogPrefix%%%n.%encoderLogExtension%" >> "%logPrefix%%logName%.%logExtension%"
        ECHO.|tee -a "%logPrefix%%logName%.%logExtension%"
)

:end

ECHO Finish: !TIME! !DATE!|tee -a "%logPrefix%%logName%.%logExtension%"
ECHO.|tee -a "%logPrefix%%logName%.%logExtension%"
ECHO ================================================================
ECHO.

:clean-up

ping 127.0.0.1 -n 1 -w 1000 >NUL 2>&1
DEL "%encoderLogPrefix%*.%encoderLogExtension%" >NUL 2>&1
DEL "*.stats" >NUL 2>&1
DEL "*.mbtree" >NUL 2>&1
DEL "encode.mkv" >NUL 2>&1
MOVE "%logPrefix%%logName%.%logExtension%" .. >NUL 2>&1
POPD

ECHO.
SET /p wait=Hit ENTER to open %logPrefix%%logName%.%logExtension% and exit.
start /b %logViewer% "%logPrefix%%logName%.%logExtension%"

:exit